const express = require("express");
const { GlobalInsert } = require("../../GlobalFunctions/GlobalCreate");
const router = express.Router();
const tableNames = require("../../Utils/allTableNames");
const pool = require("../../Utils/db");
const response = require("../../GlobalResponse/RESPONSE");
const moment = require("moment-timezone");

router.post("/createCenterline", (req, res) => {
  try {
    console.log("Req Body: ", req.body);

    const date = req.body.centerlines[0].date;
    let dateToUpdateC, dateToUpdate;

    const createDateToUpdate = (frequency, date) => {
      let dateToUpdate = moment.tz(date, "Asia/Karachi");
      switch (frequency) {
        case "Daily":
          dateToUpdate = dateToUpdate.add(1, "days");
          break;
        case "Weekly":
          dateToUpdate = dateToUpdate.add(1, "weeks");
          break;
        case "Bi-Weekly":
          dateToUpdate = dateToUpdate.add(2, "weeks");
          break;
        case "Monthly":
          dateToUpdate = dateToUpdate.add(1, "months");
          break;
        case "Quarterly":
          dateToUpdate = dateToUpdate.add(4, "months");
          break;
        case "Yearly":
          dateToUpdate = dateToUpdate.add(1, 'years');
          break;
          case "Shiftly":
          return "";
        default:
          dateToUpdate = dateToUpdate.add(1, "days");
          
      }
      if (dateToUpdate.day() === 0) {
        dateToUpdate = dateToUpdate.add(1, "days");
      }
      return dateToUpdate.format("YYYY-MM-DD");
    };

    dateToUpdateC = createDateToUpdate(req.body.frequency, date);

    console.log("Date To Update: ", dateToUpdateC);

    let payload1 = {
      tableName: tableNames.centerline,
      databaseFields: {
        area: req.body.area,
        machine: req.body.machine,
        product: req.body.product,
        equipmentOwnerId: req.body.equipmentOwnerId,
        equipmentOwner: req.body.equipmentOwner,
        frequency: req.body.frequency,
        date: date,
        dateToUpdate: dateToUpdateC,
      },
    };

    var centerlineId, centerlineItemId;
    pool.getConnection((error, connection) => {
      if (error) {
        console.log(
          "Error in Database Connection (Create Centerline Table): ",
          error.message
        );
        return res.send(
          response(
            false,
            "Error in Database Connection (Create Centerline Table): " +
              error.message,
            {}
          )
        );
      } else {
        connection.query(
          `INSERT INTO ${payload1.tableName} SET ?`,
          payload1.databaseFields,
          (err, result) => {
            connection.release();
            if (err) {
              console.log(err);
              return res.send(response(false, "error while inserting", {}));
            } else {
              console.log("Successfully Added Centerline");

              centerlineId = result["insertId"];

              console.log("Centerline ID: ", centerlineId);

              let payload = {
                tableName: tableNames.feedback,
                databaseFields: {
                  centerlineId: centerlineId,
                  area: req.body.area,
                  machine: req.body.machine,
                  product: req.body.product,
                  equipmentOwnerId: req.body.equipmentOwnerId,
                  equipmentOwner: req.body.equipmentOwner,
                  frequency: req.body.frequency,
                  date: date,
                  dateToUpdate: dateToUpdateC
                },
              };

              connection.query(
                `INSERT INTO ${payload.tableName} SET ?`,
                payload.databaseFields,
                (err, result) => {
                  connection.release();
                  if (err) {
                    console.log(err);
                    return res.send(response(false, "error while inserting", {}));
                  } else {
                    console.log("Successfully Added Feedback");

                    req.body.centerlines.forEach((items) => {
                      const {
                        centerlineName,
                        targetValue,
                        minimumValue,
                        maximumValue,
                        units,
                        qualityCritical,
                        safetyCritical,
                        date,
                        time,
                      } = items;

                      dateToUpdate = createDateToUpdate(req.body.frequency, date);

                      console.log("Date To Update: ", dateToUpdate);

                      console.log("Centerline Id: ", centerlineId);

                      let payload2 = {
                        tableName: tableNames.centerlineItems,
                        databaseFields: {
                          centerlineId: centerlineId,
                          centerlineName: centerlineName,
                          targetValue: targetValue,
                          minimumValue: minimumValue,
                          maximumValue: maximumValue,
                          units: units,
                          frequency: req.body.frequency,
                          qualityCritical: qualityCritical,
                          safetyCritical: safetyCritical,
                          date: date,
                          time: time,
                          dateToUpdate: dateToUpdate,
                        },
                      };

                      connection.query(
                        `INSERT INTO ${payload2.tableName} SET ?`,
                        payload2.databaseFields,
                        (error, result) => {
                          connection.release();
                          if (error) {
                            console.log("Error From Items Tables", error);
                            return res.send(response(false, error.message, {}));
                          } else {
                            centerlineItemId = result["insertId"];
                            let payload3 = {
                              tableName: tableNames.centerlineItems,
                              databaseFields: {
                                centerlineId: centerlineId,
                                centerlineItemId: centerlineItemId,
                                centerlineName: centerlineName,
                                targetValue: targetValue,
                                minimumValue: minimumValue,
                                maximumValue: maximumValue,
                                units: units,
                                frequency: req.body.frequency,
                                qualityCritical: qualityCritical,
                                safetyCritical: safetyCritical,
                                date: date,
                                time: time,
                                dateToUpdate: dateToUpdate,
                              },
                            };
                            console.log("Centerline Item Id: ", centerlineItemId);
                            console.log("Centerline Items Inserted Successfully");
                            connection.query(
                              `INSERT INTO ${tableNames.feedbackItems} SET ?`,
                              payload3.databaseFields,
                              (error, result) => {
                                connection.release();
                                if (error) {
                                  console.log("Error From Items Tables", error);
                                  return res.send(response(false, error.message, {}));
                                } else {
                                  console.log("Feedback Items Inserted Successfully");
                                }
                              }
                            );
                          }
                        }
                      );
                    });
                    return res.send(
                      response(true, "Items Inserted Successfully", {})
                    );
                  }
                }
              );
            }
          }
        );
      }
    });
  } catch (error) {
    console.log("Catch Error: (Create Centerline)", error.message);
    return res.send(
      response(false, "Catch Error: (Create Centerline)", error.message)
    );
  }
});

module.exports = router;
