const pool  = require("../Utils/db");
const tableNames = require("../Utils/allTableNames");
const moment = require('moment-timezone');
const poolFl = require("../Utils/dbFl");
const frequencies = require("../Functions/frequencies");
const cronDataCenterline = require("../Functions/cronDataCenterline");


const cronJobCenterlineShiftly = (req, res) => {

    try {

        console.log("Centerline Shiftly Cron Job Started");
        const karachiTime = moment().tz('Asia/Karachi');
        const currentDate = karachiTime.format('YYYY-MM-DD');
        const currentTime = karachiTime.format('HH:mm');
        console.log("Current Date in Karachi:", currentDate);
        console.log("Current Time in Karachi:", currentTime);
        const currentTimeArray = currentTime.split(":");
        const currentHour = currentTimeArray[0];
        // const currentHour = "16";
        console.log("Current Hour: ", currentHour);


        console.log("In CL cronjob");
        pool.getConnection((err, connection) => {
            if (err) {
                console.log("eror while creating connection", err);
            } else {
                connection.query(`SELECT * FROM ${tableNames.centerline}`, (err, result) => {
                    connection.release();
                    if (err) {
                        console.log(err);
                    } 
                    else {
                        // console.log("Result CL: ", result); 
                        if (result.length > 0) {
                            result.forEach(item => {
                                console.log("Item CL: ", item);
                                if (item.dateToUpdate === currentDate) {                                   
                                    if (item.frequency === frequencies.shiftlyA || item.frequency === frequencies.shiftlyB ||item.frequency === frequencies.shiftlyC) {
                                        poolFl.getConnection((err, con) => {
                                            if (err) {
                                                console.log("Error while connection FL (Cron Job Centerline): ", err.message);
                                            } else {
                                                con.query(`SELECT shiftTime from ${tableNames.frequencyFL} WHERE frequency = ?`, item.frequency, (err, res) => {
                                                    con.release();
                                                    if (err) {
                                                        console.log("Error while Getting Data (Cron Job Centerline): ", err.message);
                                                    } else {
                                                        console.log("Item Before: ", item);
                                                        console.log("FL Result: ", res);
                                                        const shiftlyTime = res[0].shiftTime;
                                                        console.log("Shift Time", shiftlyTime);
                                                        // timeOutHout = timeOut.split(":").[0];
                                                        const shiftlyTimeArray = shiftlyTime.split(":");
                                                        const shiftlyTimeHour = shiftlyTimeArray[0];
                                                        console.log("Shift Time Hour", shiftlyTimeHour);
                                                        if (currentHour === shiftlyTimeHour) {
                                                            item.centerlineId= item.id;
                                                            item.userStatus=0;
                                                            let newid=item.id;
                                                            delete item.id;
                                                            item.date = currentDate;
                                                            item.dateToUpdate = moment.tz(item.dateToUpdate, 'Asia/Karachi');
                                                            item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                                            if (item.dateToUpdate.day() === 0) {
                                                                item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                                            }
                                                            item.dateToUpdate = item.dateToUpdate.format('YYYY-MM-DD');
                                                            console.log("Item now: ", item);
                                                            cronDataCenterline(item, newid, currentDate);
                                                        } else {
                                                            console.log("Shift Time Not Matched");
                                                        }
                                                        
                                                    }
                                                });
                                            }
                                        });
                                        
                                    } else {
                                        console.log("No shift");
                                    }
                                }
                            });
                        } else {
                            console.log('No records found with frequency.');
                        }
                    }
                });
            }
        });
        console.log("Centerline Shiftly Cron Job Completed");
    } catch (err) {
    console.log("Cron Job Centerline Shiftly (Catch): ", err.message);
    }
};


module.exports = { cronJobCenterlineShiftly };
